-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("trapRock")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true    
    
    if not self.loaded then
      self.activatePhysics = false
      self.activateTimer = false
      self.timer = 12
    end
  end
  
  if self.activatePhysics then
    --CheckPhysics(self)  
    AddPhysics(self)
    self.activateTimer = true
    self.activatePhysics = false
  end  
  
  if self.activateTimer then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
			self:GetComponentOfType("vHavokRigidBody", "RigidBody")
			self.RigidBody:SetLinearDamping(0.99)
			self.RigidBody:SetLinearVelocity(Vision.hkvVec3(0,0,0))
			self.RigidBody:SetAngularVelocity(Vision.hkvVec3(0,0,0))
			self.RigidBody:SetMotionType(3)						
			--[[
		  self:RemoveComponentOfType("vHavokRigidBody", "RigidBody")
			self:AddComponentOfType("vHavokRigidBody","FixedBody")
			self.FixedBody:InitConvex(mesh, scale, 3, 5)
			self.FixedBody:SetLinearDamping(0.8)
			self.FixedBody:SetMass(500)
			]]--
			self.activateTimer = false
    end
  end  
end

function OnTrigger(self, source, target)
  if target == "trapRock" then
    self.activatePhysics = true
  end
end

function AddPhysics(self)
  local mesh = self:GetMesh()
  local scale = self:GetScaling()
  local force = self:GetPosition()
  self:AddComponentOfType("vHavokRigidBody","RigidBody")
  self.RigidBody:InitConvex(mesh, scale, 1, 5)
  self.RigidBody:SetMass(2500)
  self.RigidBody:ApplyForce(force*40)
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.activatePhysics = ar:Read()
    self.activateTimer = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.activatePhysics)
    ar:Write(self.activateTimer)
    ar:Write(self.timer)
  end
end
